/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.client.music.loader.IMPMusicLoaders;
import dev.felnull.imp.client.music.loader.IMusicLoader;
import dev.felnull.imp.client.music.player.IMusicPlayer;
import dev.felnull.imp.music.MusicPlaybackInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.util.FlagThread;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MusicLoadThread
extends FlagThread {
    private static final Logger LOGGER = LogManager.getLogger(MusicLoadThread.class);
    private final MusicSource source;
    private final MusicPlaybackInfo playbackInfo;
    private final long position;
    private final MusicLoadResultListener listener;

    protected MusicLoadThread(MusicSource source, MusicPlaybackInfo playbackInfo, long position, MusicLoadResultListener listener) {
        this.setName("Music Loader Thread: " + source.getIdentifier());
        this.source = source;
        this.playbackInfo = playbackInfo;
        this.position = position;
        this.listener = listener;
    }

    @Override
    public void run() {
        CompletableFuture<Object> cf;
        long time = System.currentTimeMillis();
        ExecutorService executor = MusicEngine.getInstance().getExecutor();
        IMusicLoader loader = null;
        for (IMusicLoader ldr : IMPMusicLoaders.getLoaders()) {
            cf = CompletableFuture.supplyAsync(() -> {
                try {
                    return ldr.canLoad(this.source);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, executor);
            try {
                Boolean ret = cf.get(10L, TimeUnit.SECONDS);
                if (ret == null || !ret.booleanValue()) continue;
                loader = ldr;
                break;
            }
            catch (TimeoutException ex) {
                if (!IamMusicPlayer.CONFIG.errorLog) continue;
                LOGGER.error("Load check time out: " + this.source.getIdentifier());
            }
            catch (Exception exception) {
            }
        }
        if (this.isStopped()) {
            return;
        }
        if (loader == null) {
            if (IamMusicPlayer.CONFIG.errorLog) {
                LOGGER.error("Non existent music loader: " + this.source.getLoaderType());
            }
            this.listener.onResult(false, System.currentTimeMillis() - time, null, false);
            return;
        }
        if (this.isStopped()) {
            return;
        }
        IMusicPlayer player = null;
        try {
            IMusicPlayer finalPlayer = player = loader.createMusicPlayer(this.source);
            cf = CompletableFuture.runAsync(() -> {
                try {
                    finalPlayer.load(this.position);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, executor);
            cf.get(10L, TimeUnit.SECONDS);
            if (this.isStopped()) {
                return;
            }
            if (!player.isLoadSuccess()) {
                throw new IllegalStateException("Load failed");
            }
        }
        catch (TimeoutException ignored) {
            if (IamMusicPlayer.CONFIG.errorLog) {
                LOGGER.error("Load time out: " + this.source.getIdentifier());
            }
            player.destroy();
            if (this.isStopped()) {
                return;
            }
            this.listener.onResult(false, System.currentTimeMillis() - time, null, false);
            return;
        }
        catch (Exception ex) {
            if (player != null) {
                player.destroy();
            }
            if (IamMusicPlayer.CONFIG.errorLog) {
                LOGGER.error("Failed to load music: " + this.source.getIdentifier(), (Throwable)ex);
            }
            if (this.isStopped()) {
                return;
            }
            this.listener.onResult(false, System.currentTimeMillis() - time, null, true);
            return;
        }
        if (this.isStopped()) {
            return;
        }
        this.listener.onResult(true, System.currentTimeMillis() - time, player, false);
    }

    public MusicPlaybackInfo getPlaybackInfo() {
        return this.playbackInfo;
    }

    public long getPosition() {
        return this.position;
    }

    public MusicSource getSource() {
        return this.source;
    }

    public MusicLoadResultListener getListener() {
        return this.listener;
    }

    public static interface MusicLoadResultListener {
        public void onResult(boolean var1, long var2, IMusicPlayer var4, boolean var5);
    }
}

